#include "General.h"

StringClass IRC::White, IRC::Black, IRC::Blue, IRC::Green, IRC::Red, IRC::Brown, IRC::Purple, IRC::Orange, 
	IRC::Yellow, IRC::LightGreen, IRC::Cyan, IRC::LightCyan, IRC::LightBlue, IRC::Pink, IRC::Grey,
	IRC::LightGrey, IRC::NoMarkup, IRC::Bold;
char IRC::Buffer[1024];
int IRC::Position = 0;
clock_t IRC::Activity = 0;
ircdata* IRC::Data;
uint IRC::PINGHash, IRC::Numeric433Hash, IRC::Numeric001Hash, IRC::PRIVMSGHash;

void IRC::Load()
{
	IRC::Load_Colours();
	IRC::Load_Hashes();

	if(!IRC::Data)
	{
		IRC::Data = new ircdata;
	}
	const char *x = Connect(&IRC::Data, Settings::IRCHost, Settings::IRCPort, Settings::IRCNick, Settings::IRCNickBackup, Settings::NickServPass);
	
	if(x)
	{
		const char *z = Connect(&IRC::Data, Settings::IRCHostBackup, Settings::IRCPortBackup, Settings::IRCNick, Settings::IRCNickBackup, Settings::NickServPass);

		if(z)
		{
			Console_Output("[AzazelBot] IRC: Connection failed on both hosts!\n");
		}
		else
		{
			Console_Output("[AzazelBot] IRC: Connected to Backup IRC network..\n");
		}
	}
	else
	{
		Console_Output("[AzazelBot] IRC: Connected to main IRC network..\n");
	}
}

void IRC::Unload()
{
	if(!IRC::Data)
	{
		return;
	}

	for (int i = 0; i < IRC::Data->Channels.Count(); i++)
	{
		for (int j = 0; j < IRC::Data->Channels[i]->Users.Count(); j++)
		{
			delete Data->Channels[i]->Users[j];
		}
	}

	IRC::Data->Sock.Destroy();
	IRC::Data = 0;
	delete IRC::Data;
}

const char *IRC::Connect(ircdata **Data, const char *Host, int Port, const char *Nick, const char *Backup_Nick, const char *NSPassword)
{
	if(!IRC::Data->Sock.Client(Host, Port))
	{
		return Host;
	}
	if(!*Data)
	{
		*Data = new ircdata;
	}

	strcpy((*Data)->Host, Host);
	strcpy((*Data)->NSPassword, NSPassword);
	strcpy((*Data)->Nick, Nick);
	strcpy((*Data)->Backup_Nick, Backup_Nick);

	(*Data)->Port = Port;
	(*Data)->Ghost = 0;
	(*Data)->Ping = 1;

	Send("NICK %s\n", Nick);
	IRC::Send("USER %s 0 * : %s build-%s\n", IRC::Data->Backup_Nick, Settings::BotName, BOT_VERSION);
	return 0;
}

void IRC::Send(const char *Packet, ...)
{
	if(!IRC::Data)
	{
		return;
	}
	char buffer[2048];
	va_list va;
	_crt_va_start(va, Packet);
	vsnprintf(buffer, 2048, Packet, va);
	va_end(va);

	IRC::Data->Sock.SendData(buffer, strlen(buffer));
}

void IRC::SendC(const char *Channel, const char *Packet, ...)
{
	if(!IRC::Data)
	{
		return;
	}
	char buffer[2048];
	va_list va;
	_crt_va_start(va, Packet);
	vsnprintf(buffer, 2048, Packet, va);
	va_end(va);

	char *temp = new char[strlen(buffer)+256];
	sprintf(temp, "PRIVMSG %s :%s\n", Channel, buffer);
	IRC::Data->Sock.SendData(temp, strlen(temp));
	delete []temp;
}


void __stdcall IRC::SendC(int Type, const char *Message, ...)
{
	if(!IRC::Data)
	{
		return;
	}
	char buffer[2048];
	va_list va;
	_crt_va_start(va, Message);
	vsnprintf(buffer, 2048, Message, va);
	va_end(va);

	if(Type == CHAN_PUBLIC) // Public
	{
		char tmp[2048];
		sprintf(tmp, "PRIVMSG %s :%s\n", Settings::IRCPublicChan, buffer);
		IRC::Data->Sock.SendData(tmp, strlen(tmp));
	}
	else if(Type == CHAN_ADMIN) // Admin
	{
		char tmp[2048];
		sprintf(tmp, "PRIVMSG %s :%s\n", Settings::IRCAdminChan, buffer);
		IRC::Data->Sock.SendData(tmp, strlen(tmp));
	}
	else if(Type == CHAN_BOTH) // Public + admin
	{
		char tmp[2048];
		sprintf(tmp, "PRIVMSG %s :%s\n", Settings::IRCPublicChan, buffer);
		IRC::Data->Sock.SendData(tmp, strlen(tmp));

		char tmp2[2048];
		sprintf(tmp2, "PRIVMSG %s :%s\n", Settings::IRCAdminChan, buffer);
		IRC::Data->Sock.SendData(tmp2, strlen(tmp2));
	}
}


void IRC::SendALL(const char *Packet, ...)
{
	if(!IRC::Data)
	{
		return;
	}
	char buffer[2048];
	va_list va;
	_crt_va_start(va, Packet);
	vsnprintf(buffer, 2048, Packet, va);
	va_end(va);

	IRC::Data->Sock.SendData(buffer, strlen(buffer));
}


void IRC::Disconnect(const char *Message, ...)
{
	if(!IRC::Data)
	{
		return;
	}
	char buffer[1024];
	va_list va;
	_crt_va_start(va, Message);
	vsnprintf(buffer+6, 1024, Message, va);
	va_end(va);

	memcpy((void *)buffer, "QUIT :", 6);

	IRC::Data->Sock.SendData(buffer, strlen(buffer));
}


void IRC::Disconnect()
{
	IRC::Disconnect("");
}

void IRC::Think()
{
	if(!IRC::Data)
	{
		return;
	}

/*	if(!Glob::IRC->Sock.Is_Connected())
	{
		Commands->Send_Custom_Event(o, o, 102, 102, 0.0);
		IRC::Position = 0;
		return;
	} */

	if(IRC::Data->Ghost)
	{
		IRC::Send("PRIVMSG NickServ :GHOST %s %s\n", IRC::Data->Nick, IRC::Data->NSPassword);
		IRC::Send("NICK %s\n", IRC::Data->Nick);
		IRC::Send("USER %s 0 * : %s build-%s\n", IRC::Data->Backup_Nick, Settings::BotName, BOT_VERSION);
		IRC::Data->Ghost = 0;
	}

	for(char c;;)
	{
		if(IRC::Data->Sock.RecieveData(&c, 1))
		{
			IRC::Activity = clock();
			if(c == 13 || c == 10)
			{
				IRC::Buffer[IRC::Position] = 0;
				IRC::Position = 0;
				IRC::Callback(IRC::Data, IRC::Buffer);
				memset(IRC::Buffer, 0, 1024);
				
			}
			else
			{
				IRC::Buffer[IRC::Position] = c;
				IRC::Position++;
			}
			
		}
		else
		{
			break;
		}
	}

	if(clock() - IRC::Activity > 60000)
	{
		if(!IRC::Data->Ping)
		{
			IRC::Send("PING :%s\n", Settings::BotName);
			IRC::Data->Ping = 1;
		}
	}
	if(clock() - IRC::Activity > 1200000)
	{
		IRC::Data->Sock.Destroy();
		IRC::Activity = clock();
	}
}

bool IRC::Find_Status(const char *Nick, const char *Channel, char *access)
{
	if(!IRC::Data)
	{
		return 0;
	}
	for (int i = 0; i < IRC::Data->Channels.Count(); i++)
	{
		if(_stricmp(IRC::Data->Channels[i]->Name, Channel) == 0)
		{
			for (int j = 0; j < IRC::Data->Channels[i]->Users.Count(); j++)
			{
				if(_stricmp(IRC::Data->Channels[i]->Users[j]->Nick, Nick) == 0)
				{
					*access = IRC::Data->Channels[i]->Users[j]->Modes;
					return 1;
				}
				
			}
			
		}
	}
	return 0;
}

void IRC::Callback(ircdata *irc, const char *Packet)
{
	Tokenizer Tokens(Packet);

	irc->Ping = 0;
	if(Tokens.Size() == 0)
	{
		return;
	}
	uint Tokens1Hash = Tokens[1].GetHash();
	if(Tokens1Hash == IRC::PINGHash)
	{
		IRC::Send("PONG %s\n", Tokens[2]);
	}

	uint Tokens2Hash = Tokens[2].GetHash();

	if(Tokens2Hash == IRC::Numeric433Hash)
	{
		IRC::Send("NICK %s\n", irc->Backup_Nick);
		IRC::Send("USER %s 0 * : %s build-%s\n", irc->Backup_Nick, Settings::BotName, BOT_VERSION);
		irc->Ghost = 1;
	}
	if(Tokens2Hash == IRC::Numeric001Hash)
	{
		IRC::Send("PRIVMSG NickServ :IDENTIFY %s\n", irc->NSPassword);

	/*	irc->EXTCommands.Reset();
		char *com;
		while(irc->EXTCommands.Iterate(&com))
		{
			IRC::Send("%s\n", com);
		} */

		IRC::Send("JOIN %s\n", Settings::IRCPublicChan);
		IRC::Send("JOIN %s\n", Settings::IRCAdminChan);
//		IRC::Send("JOIN %s %s\n", c->Name, c->Key);
	}


	if(Tokens2Hash == IRC::PRIVMSGHash)
	{
		if (Tokens[4][1] != '!')
		{
			return;
		}

		StringClass Nick, Channel, Message;

		Nick = strtok(Tokens[0].Peek_Buffer(),"!");
		Nick.cropFrom(1);

		Channel = Tokens[3];

		Message += Tokens[4].Peek_Buffer()+1;
		Message += " ";

		for (int i = 5; i < Tokens.Size()+1; i++)
		{
			Message += Tokens[i];
			
			if (i != Tokens.Size())
			{
				Message += " ";
			}
		}
		Tokenizer Msg(Message);
		IRC::On_Chat(Nick, Channel, Msg);
	}
}

void IRC::On_Chat(StringClass Nick, StringClass Channel, Tokenizer Msg)
{
	if (Msg[1][0] == '!')
	{
		if (Commands::CommandTable.Exists(Msg[1]))
		{
			ChatCommand* c;
			c = Commands::CommandTable.Get(Msg[1], 0);
			c->Activate_IRC(Nick, Channel, Msg);
		}
	}

//	Console_Output("Nick = %s, Channel = %s, Message = %s\n", Nick, Channel, Msg[0]);
}

void IRC::Load_Colours()
{
	IRC::White = StringClass().getFormattedString("\x03%d", 0);
	IRC::Black = StringClass().getFormattedString("\x03%d", 1);
	IRC::Blue = StringClass().getFormattedString("\x03%d", 2);
	IRC::Green = StringClass().getFormattedString("\x03%d", 3);
	IRC::Red = StringClass().getFormattedString("\x03%d", 4);
	IRC::Brown = StringClass().getFormattedString("\x03%d", 5);
	IRC::Purple = StringClass().getFormattedString("\x03%d", 6);
	IRC::Orange = StringClass().getFormattedString("\x03%d", 7);
	IRC::Yellow = StringClass().getFormattedString("\x03%d", 8);
	IRC::LightGreen = StringClass().getFormattedString("\x03%d", 9);
	IRC::Cyan = StringClass().getFormattedString("\x03%d", 10);
	IRC::LightCyan = StringClass().getFormattedString("\x03%d", 11);
	IRC::LightBlue = StringClass().getFormattedString("\x03%d", 12);
	IRC::Pink = StringClass().getFormattedString("\x03%d", 13);
	IRC::Grey = StringClass().getFormattedString("\x03%d", 14);
	IRC::LightGrey = StringClass().getFormattedString("\x03%d", 15);

	IRC::NoMarkup = StringClass().getFormattedString("\x0F");
	IRC::Bold = StringClass().getFormattedString("\x02");
}

void IRC::Load_Hashes()
{
	IRC::PINGHash = StringClass("PING").GetHash();
	IRC::PRIVMSGHash = StringClass("PRIVMSG").GetHash();
	IRC::Numeric433Hash = StringClass("433").GetHash();
	IRC::Numeric001Hash = StringClass("001").GetHash();
}